using System;
using System.Runtime.InteropServices;

namespace ComiDll
{
	/// <summary>
	/// ImportComiDasDLL   Դϴ.
	/// </summary>
    
    [System.Security.SuppressUnmanagedCodeSecurity]
    public  unsafe class SafeNativeMethods
    {
        [StructLayout(LayoutKind.Sequential/*, Pack=1*/)]
        public  struct ScanData
        {
            [MarshalAs(UnmanagedType.ByValArray, SizeConst = 1024)]
            public  float[] fData;
        }
        
        // COMI-DAQ Device ID
        public  enum TCmDeviceID
        {
            // CP-Seriese
	        CP101 = 0xC101, 
            CP201 = 0xC201, 
            CP301 = 0xC301, 
            CP302 = 0xC302, 
            CP401 = 0xC401, 
            CP501 = 0xC501, 
            SD101 = 0xB101,
	        // SD-Seriese
	        SD102 = 0xB102, 
            SD103 = 0xB103, 
            SD104 = 0xB104, 
            SD201 = 0xB201, 
            SD202 = 0xB202, 
            SD203 = 0xB203, 
            SD301 = 0xB301,
            SD302 = 0xB302,
	        SD401 = 0xB401, 
            SD402 = 0xB402, 
            SD403 = 0xB403, 
            SD404 = 0xB404,
            SD414 = 0xB414,
            SD424 = 0xB424, 
            SD501 = 0xB501, 
            SD502 = 0xB502, 
            LX101 = 0xA101,
	        // LX-Seriese
	        LX102 = 0xA102, 
            LX103 = 0xA103, 
            LX201 = 0xA201, 
            LX202 = 0xA202, 
            LX203 = 0xA203, 
            LX301 = 0xA301, 
            LX401 = 0xA401,
	        LX402 = 0xA402,
        }


        public  enum TCdAiScanTrs
        {
            cmTRS_SINGLE = 1,
            cmTRS_BLOCK = 2,
            cmTRS_BLOCK_EXT = 3
        }

        public  enum TCdVarType
        {
            VT_SHORT = 0, VT_FLOAT, VT_DOUBLE
        }

        public  struct TComiDevInfo
        {
            public  ushort wSubSysID;
            public  uint nInstance;

            [MarshalAs(UnmanagedType.ByValArray, SizeConst = 20)]
            public  char[] szDevName;
            public  byte bDevCaps;
            public  byte nNumAdChan, nNumDaChan, nNumDiChan, nNumDoChan, nNumCntrChan;
        }

        public  struct TComiDevList
        {
            public  ushort nNumDev;

            [MarshalAs(UnmanagedType.ByValArray, SizeConst = 16)]
            public  TComiDevInfo[] DevInfo;
        }

        public  struct TScanFileHead
        {
            //[MarshalAs(UnmanagedType.ByValTStr, SizeConst = 13)]
            public  String szDate;

            //[MarshalAs(UnmanagedType.ByValTStr, SizeConst = 10)]
            public  String szTime;

            public  int nNumChan;

            [MarshalAs(UnmanagedType.ByValArray, SizeConst = 64)]
            public  int[] nChanList;

            public  int dmin, dmax;


            [MarshalAs(UnmanagedType.ByValArray, SizeConst = 64)]
            public  float[] vmin;
            [MarshalAs(UnmanagedType.ByValArray, SizeConst = 64)]
            public  float[] vmax;

            public  uint dwSavedScanCnt;
        }         

        public  struct TPidParams
        {
            public  float Ref, lim_h, lim_l;
            public  float Kp;
            public  float Td, Ti;
            public  int ch_ref, ch_ad, ch_da;
        }

        public  struct THelicalUserInfo
        {
            public  int c_map, z_axis;
            public  double c_xcen, c_ycen;
            public  int c_dir;
            public  int c_num;
            public  double c_la;
            public  double z_dist;
        }

        public  delegate void EventFunc(IntPtr lParam);

    

 //__________ General Functions ________________________________________________//
 
 //COMIDAS_DEVID deviceID
        [DllImport("Comidll.dll", EntryPoint = "COMI_LoadDevice", CallingConvention = CallingConvention.Cdecl)]
		public  static extern unsafe IntPtr	COMI_LoadDevice(
            [MarshalAs(UnmanagedType.I4)] int deviceID, 
            [MarshalAs(UnmanagedType.I4)] int instance);

        //[DllImport("Comidll.dll", EntryPoint = "COMI_UnloadDll", CallingConvention = CallingConvention.Cdecl)]
        //public static extern unsafe void COMI_UnloadDll();

        [DllImport("Comidll.dll", EntryPoint = "COMI_UnloadDevice", CallingConvention = CallingConvention.Cdecl)]
		public  static extern unsafe void	COMI_UnloadDevice(
            IntPtr hDevice );
        
// TComiDevList
		[DllImport("Comidll.dll", EntryPoint = "COMI_GetAvailDevList", CallingConvention=CallingConvention.Cdecl)]
		public  static extern unsafe int	COMI_GetAvailDevList(
            ref ComiDll.SafeNativeMethods.TComiDevList pDevList);
        
// TComiDevInfo
        [DllImport("Comidll.dll", EntryPoint = "COMI_GetDevInfo", CallingConvention = CallingConvention.Cdecl)]
		public  static extern unsafe int	COMI_GetDevInfo(
            IntPtr hDevice ,
            ref ComiDll.SafeNativeMethods.TComiDevInfo pDevInfo);

        [DllImport("Comidll.dll", EntryPoint = "COMI_Write8402", CallingConvention = CallingConvention.Cdecl)]
		public  static extern unsafe void	COMI_Write8402(
            IntPtr hDevice , 
            [MarshalAs(UnmanagedType.I4)] int  ch,
            [MarshalAs(UnmanagedType.I4)] int  addr,
            [MarshalAs(UnmanagedType.I4)] int  data);

        [DllImport("Comidll.dll", EntryPoint = "COMI_WriteEEPR", CallingConvention = CallingConvention.Cdecl)]
		public  static extern unsafe void	COMI_WriteEEPR(
            IntPtr hDevice ,
            [MarshalAs(UnmanagedType.I4)] int  addr,
            [MarshalAs(UnmanagedType.I4)] int  data);

        [DllImport("Comidll.dll", EntryPoint = "COMI_ReadEEPR", CallingConvention = CallingConvention.Cdecl)]
		public  static extern unsafe int		COMI_ReadEEPR(
            IntPtr hDevice ,
            [MarshalAs(UnmanagedType.I4)] int  addr);
 
 //__________ A/D General Functions ________________________________________________//

        [DllImport("Comidll.dll", EntryPoint = "COMI_AD_SetRange", CallingConvention = CallingConvention.Cdecl)]
		public  static extern unsafe int	COMI_AD_SetRange(
            IntPtr hDevice , 
            [MarshalAs(UnmanagedType.I4)] int  ch,
            [MarshalAs(UnmanagedType.R4)] float vmin,
            [MarshalAs(UnmanagedType.R4)] float vmax);

        [DllImport("Comidll.dll", EntryPoint = "COMI_AD_GetDigit", CallingConvention = CallingConvention.Cdecl)]
		public  static extern unsafe short	COMI_AD_GetDigit(
            IntPtr hDevice ,
            [MarshalAs(UnmanagedType.I4)] int  ch);

        [DllImport("Comidll.dll", EntryPoint = "COMI_AD_GetVolt", CallingConvention = CallingConvention.Cdecl)]
		public  static extern unsafe float	COMI_AD_GetVolt(
            IntPtr hDevice , 
            [MarshalAs(UnmanagedType.I4)] int  ch);
 
 //__________ A/D Unlimited Scan Functions _________________________________//
        
		[DllImport("Comidll.dll", EntryPoint = "COMI_US_Start")]
		public  static extern unsafe int	COMI_US_Start(
            IntPtr hDevice ,
            [MarshalAs(UnmanagedType.I4)] int  numCh, 
            [MarshalAs(UnmanagedType.LPArray, ArraySubType = UnmanagedType.I4)] int[] chanList,
            [MarshalAs(UnmanagedType.I4)] int scanFreq, [MarshalAs(UnmanagedType.I4)] int msb, 
            [MarshalAs(UnmanagedType.I4)] int  trsMethod);
        
		[DllImport("Comidll.dll", EntryPoint = "COMI_US_StartEx")]
		public  static extern unsafe int	COMI_US_StartEx(
            IntPtr hDevice ,
            [MarshalAs(UnmanagedType.I4)] int dwScanFreq, 
            [MarshalAs(UnmanagedType.I4)] int nFrameSize,
            [MarshalAs(UnmanagedType.I4)] int nBufSizeGain);
        
		[DllImport("Comidll.dll", EntryPoint = "COMI_US_Stop")]
		public  static extern unsafe int	COMI_US_Stop(
            IntPtr hDevice , 
            [MarshalAs(UnmanagedType.I4)] int bReleaseBuf);
        
		[DllImport("Comidll.dll", EntryPoint = "COMI_US_SetPauseAtFull")]
		public  static extern unsafe int	COMI_US_SetPauseAtFull(
            IntPtr hDevice , 
            [MarshalAs(UnmanagedType.I4)] int bPauseAtFull);
        
		[DllImport("Comidll.dll", EntryPoint = "COMI_US_Resume")]
		public  static extern unsafe int	COMI_US_Resume(
            IntPtr hDevice );
        
		[DllImport("Comidll.dll", EntryPoint = "COMI_US_ChangeScanFreq")]
		public  static extern unsafe int	COMI_US_ChangeScanFreq(
            IntPtr hDevice ,
            [MarshalAs(UnmanagedType.I4)] int dwScanFreq);
        
		[DllImport("Comidll.dll", EntryPoint = "COMI_US_ResetCount")]
		public  static extern unsafe void	COMI_US_ResetCount(
            IntPtr hDevice );
        
		[DllImport("Comidll.dll", EntryPoint = "COMI_US_ChangeSampleFreq")]
		public  static extern unsafe void	COMI_US_ChangeSampleFreq(
            IntPtr hDevice ,
            [MarshalAs(UnmanagedType.I4)] int dwSampleFreq);
        
		[DllImport("Comidll.dll", EntryPoint = "COMI_US_CurCount")]
		public  static extern unsafe int	COMI_US_CurCount(
            IntPtr hDevice );
        
		[DllImport("Comidll.dll", EntryPoint = "COMI_US_SBPos")]
		public  static extern unsafe int	COMI_US_SBPos(
            IntPtr hDevice , 
            [MarshalAs(UnmanagedType.I4)] int  chOrder,
            [MarshalAs(UnmanagedType.I4)] int scanCount);

// short*        
		[DllImport("Comidll.dll", EntryPoint = "COMI_US_GetBufPtr")]
		public  static extern unsafe short[]	COMI_US_GetBufPtr(
            IntPtr hDevice );
        
		[DllImport("Comidll.dll", EntryPoint = "COMI_US_ReleaseBuf")]
		public  static extern unsafe int	COMI_US_ReleaseBuf(
            IntPtr hDevice );
        
		[DllImport("Comidll.dll", EntryPoint = "COMI_US_RetrvOne")]
		public  static extern unsafe int	COMI_US_RetrvOne(
            IntPtr hDevice , 
            [MarshalAs(UnmanagedType.I4)] int  chOrder,
            [MarshalAs(UnmanagedType.I4)] int scanCount);

//TCOmiVarType VarType        
		[DllImport("Comidll.dll", EntryPoint = "COMI_US_RetrvChannel")]
        public  static extern unsafe int COMI_US_RetrvChannel(
            IntPtr hDevice , 
            [MarshalAs(UnmanagedType.I4)] int chOrder,
            [MarshalAs(UnmanagedType.I4)] int startCount, 
            [MarshalAs(UnmanagedType.I4)] int maxNumData, 
            IntPtr Buffer,
            [MarshalAs(UnmanagedType.I4)] int VarType);

//TCOmiVarType VarType  
		[DllImport("Comidll.dll", EntryPoint = "COMI_US_RetrvBlock")]
        public  static extern unsafe int COMI_US_RetrvBlock(
            IntPtr hDevice , 
            [MarshalAs(UnmanagedType.I4)] int startCount,
            [MarshalAs(UnmanagedType.I4)] int maxNumScan,
            [MarshalAs(UnmanagedType.I4)] IntPtr Buffer,
            [MarshalAs(UnmanagedType.I4)] int VarType);
        
		[DllImport("Comidll.dll", EntryPoint = "COMI_US_FileSaveFirst")]
		public  static extern unsafe int	COMI_US_FileSaveFirst(
            IntPtr hDevice ,
            [MarshalAs(UnmanagedType.LPWStr)] string szFilePath,
            [MarshalAs(UnmanagedType.I4)] int bIsFromStart);
        
		[DllImport("Comidll.dll", EntryPoint = "COMI_US_FileSaveNext")]
		public  static extern unsafe int	COMI_US_FileSaveNext(
            IntPtr hDevice );
        
		[DllImport("Comidll.dll", EntryPoint = "COMI_US_FileSaveStop")]
		public  static extern unsafe int	COMI_US_FileSaveStop(
            IntPtr hDevice );
        
		[DllImport("Comidll.dll", EntryPoint = "COMI_US_FileConvert")]
		public  static extern unsafe void	COMI_US_FileConvert(
            [MarshalAs(UnmanagedType.LPWStr)] string szBinFilePath,
            [MarshalAs(UnmanagedType.LPWStr)] string szTextFilePath,
            [MarshalAs(UnmanagedType.I4)] int nMaxDataRow);
        
		[DllImport("Comidll.dll", EntryPoint = "COMI_US_CheckFileConvert")]
		public  static extern unsafe double	COMI_US_CheckFileConvert();
        
		[DllImport("Comidll.dll", EntryPoint = "COMI_US_CancelFileConvert")]
		public  static extern unsafe void	COMI_US_CancelFileConvert();
 
 //___________ PID Functions _______________________________________________//
        
		[DllImport("Comidll.dll", EntryPoint = "COMI_PID_Enable")]
		public  static extern unsafe int	COMI_PID_Enable(
            IntPtr hDevice ); 

// TPidParams pPidParams       
        //[DllImport("Comidll.dll", EntryPoint = "COMI_PID_SetParams")]
        //public  static extern unsafe int	COMI_PID_SetParams(IntPtr hDevice , [MarshalAs(UnmanagedType.I4)] int  nNumCtrls, ref TPidParams pPidParams); 
        
		[DllImport("Comidll.dll", EntryPoint = "COMI_PID_Disable")]
		public  static extern unsafe int	COMI_PID_Disable(
            IntPtr hDevice ); 
 
 //___________ DIO Common __________________________________________________//

        [DllImport("Comidll.dll", EntryPoint = "COMI_DIO_SetUsage", CallingConvention = CallingConvention.Cdecl)]
		public  static extern unsafe void	COMI_DIO_SetUsage(
            IntPtr hDevice ,
            [MarshalAs(UnmanagedType.I4)] int  usage);

        [DllImport("Comidll.dll", EntryPoint = "COMI_DIO_GetUsage", CallingConvention = CallingConvention.Cdecl)]
		public  static extern unsafe int		COMI_DIO_GetUsage(
            IntPtr hDevice );
 
 //__________ D/I Functions ________________________________________________//

        [DllImport("Comidll.dll", EntryPoint = "COMI_DI_GetOne", CallingConvention = CallingConvention.Cdecl)]
		public  static extern unsafe int		COMI_DI_GetOne(
            IntPtr hDevice ,
            [MarshalAs(UnmanagedType.I4)] int  ch);

        [DllImport("Comidll.dll", EntryPoint = "COMI_DI_GetAll", CallingConvention = CallingConvention.Cdecl)]
		public  static extern unsafe uint	COMI_DI_GetAll(
            IntPtr hDevice );

        [DllImport("Comidll.dll", EntryPoint = "COMI_DI_GetAllEx", CallingConvention = CallingConvention.Cdecl)]
		public  static extern unsafe int	COMI_DI_GetAllEx(
            IntPtr hDevice ,
            [MarshalAs(UnmanagedType.I4)] int  nGroupIdx);
 
 //__________ D/O Functions ________________________________________________//

        [DllImport("Comidll.dll", EntryPoint = "COMI_DO_PutOne", CallingConvention = CallingConvention.Cdecl)]
		public  static extern unsafe int	COMI_DO_PutOne(
            IntPtr hDevice , 
            [MarshalAs(UnmanagedType.I4)] int  ch, 
            [MarshalAs(UnmanagedType.I4)] int  status);

        [DllImport("Comidll.dll", EntryPoint = "COMI_DO_PutAll", CallingConvention = CallingConvention.Cdecl)]
		public  static extern unsafe int	COMI_DO_PutAll(
            IntPtr hDevice ,
            [MarshalAs(UnmanagedType.U4)] uint dwStatuses);

        [DllImport("Comidll.dll", EntryPoint = "COMI_DO_PutAllEx", CallingConvention = CallingConvention.Cdecl)]
		public  static extern unsafe void	COMI_DO_PutAllEx(
            IntPtr hDevice , 
            [MarshalAs(UnmanagedType.I4)] int  nGroupIdx,
            [MarshalAs(UnmanagedType.I4)] int dwStatuses);

        [DllImport("Comidll.dll", EntryPoint = "COMI_DO_GetOne", CallingConvention = CallingConvention.Cdecl)]
		public  static extern unsafe int COMI_DO_GetOne(
            IntPtr hDevice ,
            [MarshalAs(UnmanagedType.I4)] int  ch);
        
		[DllImport("Comidll.dll", EntryPoint = "COMI_DO_GetAll", CallingConvention = CallingConvention.Cdecl)]
		public  static extern unsafe uint	COMI_DO_GetAll(
            IntPtr hDevice );

        [DllImport("Comidll.dll", EntryPoint = "COMI_DO_GetAllEx", CallingConvention = CallingConvention.Cdecl)]
		public  static extern unsafe int	COMI_DO_GetAllEx(
            IntPtr hDevice ,
            [MarshalAs(UnmanagedType.I4)] int  nGroupIdx);
 
 //__________ D/A Functions ________________________________________________//

        [DllImport("Comidll.dll", EntryPoint = "COMI_DA_Out", CallingConvention = CallingConvention.Cdecl)]
		public  static extern unsafe bool	COMI_DA_Out(
            IntPtr hDevice , 
            [MarshalAs(UnmanagedType.I4)] int  ch,
            [MarshalAs(UnmanagedType.R4)] float volt);

        [DllImport("Comidll.dll", EntryPoint = "COMI_DA_SetRange", CallingConvention = CallingConvention.Cdecl)]
		public  static extern unsafe void	COMI_DA_SetRange(
            IntPtr hDevice ,
            [MarshalAs(UnmanagedType.I4)] int  ch,
            [MarshalAs(UnmanagedType.I4)] int  VMin,
            [MarshalAs(UnmanagedType.I4)] int  VMax);

        [DllImport("Comidll.dll", EntryPoint = "COMI_WFM_Start", CallingConvention = CallingConvention.Cdecl)]
		public  static extern unsafe int	COMI_WFM_Start(
            IntPtr hDevice ,
            [MarshalAs(UnmanagedType.I4)] int  ch,
            [MarshalAs(UnmanagedType.LPArray, ArraySubType = UnmanagedType.R8)] ref double Buffer,
            [MarshalAs(UnmanagedType.I4)] int nNumData, 
            [MarshalAs(UnmanagedType.I4)] int nPPS,
            [MarshalAs(UnmanagedType.I4)] int  nMaxLoops);

        [DllImport("Comidll.dll", EntryPoint = "COMI_WFM_RateChange", CallingConvention = CallingConvention.Cdecl)]
		public  static extern unsafe int	COMI_WFM_RateChange(
            IntPtr hDevice ,
            [MarshalAs(UnmanagedType.I4)] int  ch,
            [MarshalAs(UnmanagedType.I4)] int nPPS);

        [DllImport("Comidll.dll", EntryPoint = "COMI_WFM_GetCurPos", CallingConvention = CallingConvention.Cdecl)]
		public  static extern unsafe int	COMI_WFM_GetCurPos(
            IntPtr hDevice , 
            [MarshalAs(UnmanagedType.I4)] int  ch);
        
		[DllImport("Comidll.dll", EntryPoint = "COMI_WFM_GetCurLoops")]
		public  static extern unsafe int	COMI_WFM_GetCurLoops(
            IntPtr hDevice , 
            [MarshalAs(UnmanagedType.I4)] int  ch);
        
		[DllImport("Comidll.dll", EntryPoint = "COMI_WFM_Stop")]
		public  static extern unsafe void	COMI_WFM_Stop(
            IntPtr hDevice ,
            [MarshalAs(UnmanagedType.I4)] int  ch);
 
 //__________ Counter Functions ____________________________________________//

        [DllImport("Comidll.dll", EntryPoint = "COMI_SetCounter", CallingConvention = CallingConvention.Cdecl)]
		public  static extern unsafe void	COMI_SetCounter(
            IntPtr hDevice , 
            [MarshalAs(UnmanagedType.I4)] int  ch,
            [MarshalAs(UnmanagedType.I4)] int  rw, 
            [MarshalAs(UnmanagedType.I4)] int  op, 
            [MarshalAs(UnmanagedType.I4)] int  bcd_bin,
            [MarshalAs(UnmanagedType.I4)] int load_value);

        [DllImport("Comidll.dll", EntryPoint = "COMI_LoadCount", CallingConvention = CallingConvention.Cdecl)]
		public  static extern unsafe void	COMI_LoadCount(
            IntPtr hDevice , 
            [MarshalAs(UnmanagedType.I4)] int  ch, 
            [MarshalAs(UnmanagedType.I4)] int load_value);

        [DllImport("Comidll.dll", EntryPoint = "COMI_ReadCount", CallingConvention = CallingConvention.Cdecl)]
		public  static extern unsafe ushort	COMI_ReadCount(
            IntPtr hDevice , 
            [MarshalAs(UnmanagedType.I4)] int  ch);

        [DllImport("Comidll.dll", EntryPoint = "COMI_ReadCounter32", CallingConvention = CallingConvention.Cdecl)]
		public  static extern unsafe uint 	COMI_ReadCounter32(
            IntPtr hDevice , 
            [MarshalAs(UnmanagedType.I4)] int  ch);

        [DllImport("Comidll.dll", EntryPoint = "COMI_ClearCounter32", CallingConvention = CallingConvention.Cdecl)]
		public  static extern unsafe void 	COMI_ClearCounter32(
            IntPtr hDevice ,
            [MarshalAs(UnmanagedType.I4)] int  ch);

        [DllImport("Comidll.dll", EntryPoint = "COMI_FC_SelectGate", CallingConvention = CallingConvention.Cdecl)]
		public  static extern unsafe void	COMI_FC_SelectGate(
            IntPtr hDevice ,
            [MarshalAs(UnmanagedType.I4)] int  ch,
            [MarshalAs(UnmanagedType.I4)] int  nGateIndex);
        
		[DllImport("Comidll.dll", EntryPoint = "COMI_FC_GateTime")]
		public  static extern unsafe int	COMI_FC_GateTime(
            IntPtr hDevice , 
            [MarshalAs(UnmanagedType.I4)] int  ch);
        
		[DllImport("Comidll.dll", EntryPoint = "COMI_FC_ReadCount")]
		public  static extern unsafe int	COMI_FC_ReadCount(
            IntPtr hDevice ,
            [MarshalAs(UnmanagedType.I4)] int  ch);
        
		[DllImport("Comidll.dll", EntryPoint = "COMI_FC_ReadFreq")]
		public  static extern unsafe int	COMI_FC_ReadFreq(
            IntPtr hDevice ,
            [MarshalAs(UnmanagedType.I4)] int  ch);
 
 
		[DllImport("Comidll.dll", EntryPoint = "COMI_ENC_Config")]
		public  static extern unsafe void	COMI_ENC_Config(
            IntPtr hDevice ,
            [MarshalAs(UnmanagedType.I4)] int  ch, 
            [MarshalAs(UnmanagedType.I4)] int  mode,
            [MarshalAs(UnmanagedType.I4)] int bResetByZ);
        
		[DllImport("Comidll.dll", EntryPoint = "COMI_ENC_Reset")]
		public  static extern unsafe void	COMI_ENC_Reset(
            IntPtr hDevice ,
            [MarshalAs(UnmanagedType.I4)] int  ch);
        
		[DllImport("Comidll.dll", EntryPoint = "COMI_ENC_Load")]
		public  static extern unsafe void	COMI_ENC_Load(
            IntPtr hDevice ,
            [MarshalAs(UnmanagedType.I4)] int  ch, 
            [MarshalAs(UnmanagedType.I4)] int Count);
        
		[DllImport("Comidll.dll", EntryPoint = "COMI_ENC_Read")]
		public  static extern unsafe int	COMI_ENC_Read(
            IntPtr hDevice ,
            [MarshalAs(UnmanagedType.I4)] int  ch);
        
		[DllImport("Comidll.dll", EntryPoint = "COMI_ENC_ResetZ")]
		public  static extern unsafe void	COMI_ENC_ResetZ(
            IntPtr hDevice ,
            [MarshalAs(UnmanagedType.I4)] int  ch);
        
		[DllImport("Comidll.dll", EntryPoint = "COMI_ENC_LoadZ")]
		public  static extern unsafe void	COMI_ENC_LoadZ(
            IntPtr hDevice , 
            [MarshalAs(UnmanagedType.I4)] int  ch, 
            [MarshalAs(UnmanagedType.I4)] int  count);
        
		[DllImport("Comidll.dll", EntryPoint = "COMI_ENC_ReadZ")]
		public  static extern unsafe int	COMI_ENC_ReadZ(
            IntPtr hDevice , 
            [MarshalAs(UnmanagedType.I4)] int  ch);
        
		[DllImport("Comidll.dll", EntryPoint = "COMI_PG_Start")]
		public  static extern unsafe double	COMI_PG_Start(
            IntPtr hDevice , 
            [MarshalAs(UnmanagedType.I4)] int  ch, 
            [MarshalAs(UnmanagedType.R8)] double freq,
            [MarshalAs(UnmanagedType.I4)] int num_pulses);
        
		[DllImport("Comidll.dll", EntryPoint = "COMI_PG_ChangeFreq")]
		public  static extern unsafe double	COMI_PG_ChangeFreq(
            IntPtr hDevice ,
            [MarshalAs(UnmanagedType.I4)] int  ch, 
            [MarshalAs(UnmanagedType.R8)] double freq);
        
		[DllImport("Comidll.dll", EntryPoint = "COMI_PG_IsActive")]
		public  static extern unsafe int	COMI_PG_IsActive(
            IntPtr hDevice ,
            [MarshalAs(UnmanagedType.I4)] int  ch);
        
		[DllImport("Comidll.dll", EntryPoint = "COMI_PG_Stop")]
		public  static extern unsafe void	COMI_PG_Stop(
            IntPtr hDevice ,
            [MarshalAs(UnmanagedType.I4)] int  ch);

        
		[DllImport("Comidll.dll", EntryPoint = "COMI_SD502_SetCounter")]
		public  static extern unsafe void	COMI_SD502_SetCounter(
            IntPtr hDevice , 
            [MarshalAs(UnmanagedType.I4)] int  ch,
            [MarshalAs(UnmanagedType.I4)] int  nMode, 
            [MarshalAs(UnmanagedType.I4)] int nClkSource);
        
		[DllImport("Comidll.dll", EntryPoint = "COMI_SD502_ReadNowCount")]
		public  static extern unsafe int	COMI_SD502_ReadNowCount(
            IntPtr hDevice ,
            [MarshalAs(UnmanagedType.I4)] int  ch);
        
		[DllImport("Comidll.dll", EntryPoint = "COMI_SD502_ReadOldCount")]
		public  static extern unsafe int	COMI_SD502_ReadOldCount(
            IntPtr hDevice , 
            [MarshalAs(UnmanagedType.I4)] int  ch);
        
		[DllImport("Comidll.dll", EntryPoint = "COMI_SD502_GetGateState")]
		public  static extern unsafe int	COMI_SD502_GetGateState(
            IntPtr hDevice , 
            [MarshalAs(UnmanagedType.I4)] int  ch);
        
		[DllImport("Comidll.dll", EntryPoint = "COMI_SD502_GetClkFreq")]
		public  static extern unsafe double	COMI_SD502_GetClkFreq(
            [MarshalAs(UnmanagedType.I4)] int nClkSrcIdx);
        
		[DllImport("Comidll.dll", EntryPoint = "COMI_SD502_Clear")]
		public  static extern unsafe void	COMI_SD502_Clear(
            IntPtr hDevice , 
            [MarshalAs(UnmanagedType.I4)] int  ch);
        
		[DllImport("Comidll.dll", EntryPoint = "COMI_SD502_ClearMulti")]
		public  static extern unsafe void	COMI_SD502_ClearMulti(
            IntPtr hDevice ,
            [MarshalAs(UnmanagedType.I4)] int dwCtrlBits);

 //__________ Utility Functions ____________________________________________//
        
		[DllImport("Comidll.dll", EntryPoint = "COMI_DigitToVolt")]
		public  static extern unsafe double	COMI_DigitToVolt(
            [MarshalAs(UnmanagedType.I4)] int digit, 
            [MarshalAs(UnmanagedType.R8)] double vmin, 
            [MarshalAs(UnmanagedType.R8)] double vmax);
        
		[DllImport("Comidll.dll", EntryPoint = "COMI_Digit14ToVolt")]
		public  static extern unsafe double	COMI_Digit14ToVolt(
            [MarshalAs(UnmanagedType.I4)] int digit, 
            [MarshalAs(UnmanagedType.R8)] double vmin,
            [MarshalAs(UnmanagedType.R8)] double vmax);
        
		[DllImport("Comidll.dll", EntryPoint = "COMI_Digit16ToVolt")]
		public  static extern unsafe double	COMI_Digit16ToVolt(
            [MarshalAs(UnmanagedType.I4)] int digit,
            [MarshalAs(UnmanagedType.R8)] double vmin, 
            [MarshalAs(UnmanagedType.R8)] double vmax);
        
		[DllImport("Comidll.dll", EntryPoint = "COMI_LastError")]
		public  static extern unsafe int		COMI_LastError();
        
		[DllImport("Comidll.dll", EntryPoint = "COMI_ErrorString")]
		public  static extern unsafe string COMI_ErrorString(
            [MarshalAs(UnmanagedType.I4)] int nErrCode);
        
		[DllImport("Comidll.dll", EntryPoint = "COMI_GetResources")]
		public  static extern unsafe void	COMI_GetResources(
            IntPtr hDevice ,
            [MarshalAs(UnmanagedType.LPArray, ArraySubType = UnmanagedType.I4)] int[]  pdwIntVect,
            [MarshalAs(UnmanagedType.LPArray, ArraySubType = UnmanagedType.I4)] int[] pdwIoPorts,
            [MarshalAs(UnmanagedType.I4)] int  nNumPorts, 
            [MarshalAs(UnmanagedType.LPArray, ArraySubType = UnmanagedType.I4)] int[] pdwMemPorts, 
            [MarshalAs(UnmanagedType.I4)] int  nNumMemPorts);
        
		[DllImport("Comidll.dll", EntryPoint = "COMI_WriteIoPortDW")]
		public  static extern unsafe void	COMI_WriteIoPortDW(
            IntPtr hDevice ,
            [MarshalAs(UnmanagedType.I4)] int dwPortBase, 
            [MarshalAs(UnmanagedType.I4)] int nOffset, 
            [MarshalAs(UnmanagedType.I4)] int dwOutVal);
        
		[DllImport("Comidll.dll", EntryPoint = "COMI_ReadIoPortDW")]
		public  static extern unsafe int	COMI_ReadIoPortDW(
            IntPtr hDevice , 
            [MarshalAs(UnmanagedType.I4)] int dwPortBase, 
            [MarshalAs(UnmanagedType.I4)] int nOffset);
        
		[DllImport("Comidll.dll", EntryPoint = "COMI_WriteMemPortDW")]
		public  static extern unsafe void	COMI_WriteMemPortDW(
            IntPtr hDevice ,
            [MarshalAs(UnmanagedType.I4)] int dwPortBase, 
            [MarshalAs(UnmanagedType.I4)] int nOffset, 
            [MarshalAs(UnmanagedType.I4)] int dwOutVal);
        
		[DllImport("Comidll.dll", EntryPoint = "COMI_ReadMemPortDW")]
		public  static extern unsafe int	COMI_ReadMemPortDW(
            IntPtr hDevice , 
            [MarshalAs(UnmanagedType.I4)] int dwPortBase, 
            [MarshalAs(UnmanagedType.I4)] int nOffset);
        
		[DllImport("Comidll.dll", EntryPoint = "COMI_GotoURL")]
		public  static extern unsafe void	COMI_GotoURL(
            [MarshalAs(UnmanagedType.LPWStr)] string szUrl, 
            [MarshalAs(UnmanagedType.I4)] int bMaximize);
    }
}

